/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.associations;

import filenet.vw.api.VWAssociationDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.canvas.process.VWDesignerBasePropertyPanel;
import filenet.vw.toolkit.design.canvas.process.VWPropertyMenuItem;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class VWAssociationPropertyPanel
extends VWDesignerBasePropertyPanel
implements DocumentListener,
IVWPropertyChangeSource {
    protected VWAssociationDefinition m_selectedAssociation = null;
    protected Vector m_changedItems = null;
    protected JTextField m_nameTextField;

    public VWAssociationPropertyPanel(VWAuthPropertyData authPropertyData) {
        super(authPropertyData);
    }

    public Object getDataObject() {
        return this.m_selectedAssociation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataObject(Object dataObject) {
        if (dataObject == null || !(dataObject instanceof VWAssociationDefinition) || dataObject == this.m_selectedAssociation) {
            return;
        }
        this.m_selectedAssociation = (VWAssociationDefinition)dataObject;
        try {
            try {
                this.m_nameTextField.getDocument().removeDocumentListener(this);
                this.m_nameTextField.setText("");
                if (this.m_selectedAssociation != null) {
                    this.m_nameTextField.setText(this.m_selectedAssociation.getName());
                }
                this.setEnabled(this.m_authPropertyData.isCurrentMapEditable());
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var4_3 = null;
                this.m_nameTextField.getDocument().addDocumentListener(this);
            }
            Object var4_2 = null;
            this.m_nameTextField.getDocument().addDocumentListener(this);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.m_nameTextField.getDocument().addDocumentListener(this);
            throw throwable;
        }
    }

    public String getDisplayName() {
        String name = this.getToolTip();
        if (name != null) {
            name = this.getFormattedTabName(name);
        }
        return name;
    }

    public String getToolTip() {
        if (this.m_selectedAssociation != null) {
            return VWPropertyMenuItem.getDisplayName(this.m_selectedAssociation);
        }
        return null;
    }

    public Icon getIcon() {
        return VWImageLoader.createImageIcon("association_16.gif");
    }

    public void displayHelpPage() {
        VWHelp.displayPage(VWHelp.Help_Process_Designer + "bpfdh136.htm");
    }

    public void releaseReferences() {
        if (this.m_nameTextField != null) {
            this.m_nameTextField.getDocument().removeDocumentListener(this);
            this.m_nameTextField.removeAll();
            this.m_nameTextField = null;
        }
        super.releaseReferences();
    }

    public void changedUpdate(DocumentEvent event) {
    }

    public void insertUpdate(DocumentEvent event) {
        if (this.m_selectedAssociation == null) {
            return;
        }
        if (event.getDocument() == this.m_nameTextField.getDocument()) {
            this.updateName();
        }
    }

    public void removeUpdate(DocumentEvent event) {
        if (this.m_selectedAssociation == null) {
            return;
        }
        if (event.getDocument() == this.m_nameTextField.getDocument()) {
            this.updateName();
        }
    }

    public void notifyPropertyChange() {
        this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 577);
    }

    public Vector getItemsChanged() {
        return this.m_changedItems;
    }

    protected void createControls() {
        try {
            this.setLayout(new BorderLayout(6, 6));
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.add((Component)this.getNamePanel(), "First");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getNamePanel() {
        try {
            VWToolbarBorder associationNameBorder = new VWToolbarBorder(VWResource.s_association);
            JPanel childPanel = associationNameBorder.getClientPanel();
            childPanel.setLayout(new BorderLayout());
            this.m_nameTextField = new JTextField("", 15);
            this.m_nameTextField.setName("m_nameTextField_VWAssociationPropertyPanel");
            this.m_nameTextField.setEditable(true);
            this.m_nameTextField.getDocument().addDocumentListener(this);
            this.m_controls.add(this.m_nameTextField);
            childPanel.add((Component)this.m_nameTextField, "First");
            return associationNameBorder;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void updateName() {
        try {
            if (this.m_selectedAssociation != null && this.m_nameTextField != null) {
                String name = this.m_nameTextField.getText();
                String blankName = VWPropertyMenuItem.getBlankName(this.m_selectedAssociation);
                if ((name.length() == 0 || name.equals(blankName)) && this.m_selectedAssociation.getName() == null) {
                    return;
                }
                this.m_selectedAssociation.setName(name);
                this.m_authPropertyData.setDirty();
                this.m_changedItems = new Vector();
                this.m_changedItems.addElement(this.m_selectedAssociation);
                this.notifyPropertyChange();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

